<?php include "koneksi.php"; ?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Sistem Rekomendasi Film - Erik SI-B</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background-color: #f0f4f8;
            margin: 0;
            padding: 0;
        }

        html {
            scroll-behavior: smooth;
        }

        .container {
            width: 90%;
            max-width: 1000px;
            margin: auto;
            background: white;
            padding: 30px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            margin-top: 40px;
            border-radius: 10px;
        }

        header {
            display: flex;
            align-items: center;
            margin-bottom: 30px;
        }

        .profile-pic {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            margin-right: 20px;
            border: 2px solid #007BFF;
        }

        h1 {
            margin: 0;
            color: #007BFF;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            background-color: #fff;
        }

        th, td {
            border: 1px solid #ccc;
            text-align: center;
            padding: 8px;
        }

        th {
            background-color: #007BFF;
            color: white;
        }

        .reload-button {
            background-color: #28a745;
            border: none;
            color: white;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            margin-bottom: 30px;
            transition: background-color 0.3s;
        }

        .reload-button:hover {
            background-color: #218838;
        }

        .footer {
            margin-top: 40px;
        }

        .prediction-card {
            background-color: #fff3cd;
            color: #856404;
            padding: 20px;
            border-radius: 10px;
            border: 1px solid #ffeeba;
            font-size: 18px;
            font-weight: bold;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            text-align: center;
        }

        .prediction-card span {
            font-size: 30px;
            color: #dc3545;
        }

        .stars {
            color: gold;
            font-size: 24px;
        }
    </style>

    <script>
        function scrollToHasil() {
            document.getElementById('hasil-prediksi').scrollIntoView({ behavior: 'smooth' });
        }
    </script>
</head>
<body>
    <div class="container">
        <header>
            <img src="erik.png" alt="Foto Erik" class="profile-pic">
            <div>
                <h1>Erik Agus Susilo</h1>
                <p>Mahasiswa Sistem Informasi - Kelas SI-B</p>
            </div>
        </header>

        <button class="reload-button" onclick="scrollToHasil()">🔁 Tampilkan Hasil Prediksi</button>

        <h2>Data Rating Film</h2>
        <table>
            <tr>
                <th>User</th>
                <th>Interstellar</th>
                <th>Inception</th>
                <th>Titanic</th>
                <th>Avatar</th>
                <th>Matrix</th>
            </tr>
            <?php
            $result = mysqli_query($koneksi, "SELECT * FROM user_movie_ratings");
            while ($row = mysqli_fetch_assoc($result)) {
                echo "<tr>
                    <td>{$row['user_id']}</td>
                    <td>{$row['interstellar']}</td>
                    <td>{$row['inception']}</td>
                    <td>{$row['titanic']}</td>
                    <td>{$row['avatar']}</td>
                    <td>{$row['matrix']}</td>
                </tr>";
            }
            ?>
        </table>

        <div class="footer" id="hasil-prediksi">
            <h3>Hasil Prediksi Rating U2 ke Film <em>Matrix</em></h3>
            <div class="prediction-card">
                <?php
                include "user_based_cf.php"; // Pastikan file ini menampilkan hanya angka prediksi, contoh: echo "3.8";
                
                // Tampilkan bintang berdasarkan hasil
                if (is_numeric($predicted)) {
                    $stars = round($predicted);
                    echo "<div class='stars'>";
                    for ($i = 0; $i < $stars; $i++) echo "⭐";
                    echo "</div>";
                }
                ?>
            </div>
        </div>
    </div>
</body>
</html>
