<?php
include 'koneksi.php';

$query = mysqli_query($koneksi, "SELECT * FROM user_movie_ratings");
$data = [];
while ($row = mysqli_fetch_assoc($query)) {
    $data[$row['user_id']] = [
        'Interstellar' => (int)$row['interstellar'],
        'Inception'    => (int)$row['inception'],
        'Titanic'      => (int)$row['titanic'],
        'Avatar'       => (int)$row['avatar'],
        'Matrix'       => (int)$row['matrix']
    ];
}

function pearsonSimilarity($u1, $u2) {
    $common = array_intersect_key($u1, $u2);
    $n = count($common);

    if ($n === 0) return 0;

    $sum1 = $sum2 = $sum1Sq = $sum2Sq = $pSum = 0;
    foreach ($common as $item => $_) {
        $x = $u1[$item];
        $y = $u2[$item];

        $sum1 += $x;
        $sum2 += $y;
        $sum1Sq += pow($x, 2);
        $sum2Sq += pow($y, 2);
        $pSum += $x * $y;
    }

    $num = $pSum - ($sum1 * $sum2 / $n);
    $den = sqrt(($sum1Sq - pow($sum1, 2) / $n) * ($sum2Sq - pow($sum2, 2) / $n));

    return ($den == 0) ? 0 : $num / $den;
}

$target_user = 'U2';
$movie = 'Matrix';
$weighted_sum = 0;
$similarity_total = 0;

foreach ($data as $user => $ratings) {
    if ($user == $target_user || $ratings[$movie] == 0) continue;

    $sim = pearsonSimilarity($data[$target_user], $ratings);
    if ($sim <= 0) continue;

    $weighted_sum += $sim * $ratings[$movie];
    $similarity_total += $sim;
}

$predicted = ($similarity_total > 0) ? round($weighted_sum / $similarity_total, 2) : 'Tidak dapat diprediksi';

echo "<span>$predicted</span>";
?>
